<?php $__env->startSection('content'); ?>
<?php echo $__env->make('inc.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<h2>My Assigned Students</h2>
<p><strong>Date:</strong> <?php echo e(\Carbon\Carbon::now()->format('l, F j, Y')); ?></p>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>Student Name</th>
            <th>Email</th>
            <th>Mark Attendance</th>
            <th>Lesson Learned</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $today = \Carbon\Carbon::now()->toDateString();
        ?>

        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $attendance = $attendances->where('student_id', $student->id)
                                          ->where('date', $today)
                                          ->first();
            ?>

            <tr>
                <td><?php echo e($student->name); ?></td>
                <td><?php echo e($student->email); ?></td>

                
                <td>
                    <?php if($attendance): ?>
                        <span class="badge bg-success">Marked</span>
                    <?php else: ?>
                        <form method="POST" action="<?php echo e(route('students.attendance.mark', $student->id)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success btn-sm">✔️ Mark</button>
                        </form>
                    <?php endif; ?>
                </td>

                
                <td>
                    <form method="POST" action="<?php echo e(route('students.attendance.mark', $student->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <input
                            type="text"
                            name="lesson_learned"
                            class="form-control mb-1"
                            placeholder="E.g. Learnt PHP classes"
                            value="<?php echo e($attendance->lesson_learned ?? ''); ?>"
                        >
                        <button type="submit" class="btn btn-info btn-sm">
                            <?php echo e($attendance ? 'Update Lesson' : 'Save Lesson'); ?>

                        </button>
                    </form>
                    <?php if($attendance && !$attendance->lesson_learned): ?>
                        <small class="text-muted">No comments</small>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/supervisors/assigned-students.blade.php ENDPATH**/ ?>