<?php $__env->startSection('content'); ?>
<?php echo $__env->make('inc.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <h2 class="mb-4">🗓️ Attendance Calendar</h2>

    
    <form method="GET" action="<?php echo e(route('attendance.records')); ?>">
        <div class="mb-3">
            <label class="form-label fw-bold">Select Student</label>
            <select name="student_id" onchange="this.form.submit()" class="form-control">
                <option value="">-- Choose Student --</option>
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($s->id); ?>" <?php echo e(request('student_id') == $s->id ? 'selected' : ''); ?>>
                        <?php echo e($s->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </form>

    <?php if($selectedStudent): ?>
        <div class="mb-4">
            <h4 class="fw-bold"><?php echo e($selectedStudent->name); ?> - <?php echo e(now()->format('F Y')); ?></h4>
        </div>

        <form method="POST" action="<?php echo e(route('attendance.update', $selectedStudent->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            
            <div class="table-responsive">
                <table class="table table-bordered text-center">
                    <thead class="table-light">
                        <tr>
                            <?php $__currentLoopData = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($day); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $calendar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $week): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php $__currentLoopData = $week; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td class="<?php echo e(!$day['in_month'] ? 'bg-light' : ''); ?>">
                                        <?php if($day['in_month']): ?>
                                            <label class="d-block">
                                                <input
                                                    type="checkbox"
                                                    name="attendance_dates[]"
                                                    value="<?php echo e($day['date']->format('Y-m-d')); ?>"
                                                    <?php echo e(in_array($day['date']->format('Y-m-d'), $presentDays) ? 'checked' : ''); ?>

                                                >
                                                <br>
                                                <small><?php echo e($day['date']->format('d')); ?></small> 
                                            </label>
                                        <?php endif; ?>
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary mt-3">
                    💾 Update Attendance
                </button>
            </div>
        </form>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/supervisors/attendance/calendar.blade.php ENDPATH**/ ?>