<?php $__env->startSection('content'); ?>
<?php echo $__env->make('inc.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
    .card {
        background: #ffffff;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        margin-bottom: 30px;
    }
    .card-header {
        font-size: 1.5rem;
        font-weight: 600;
        color: #004085;
        margin-bottom: 20px;
    }
    .summary-list {
        list-style: none;
        padding: 0;
    }
    .summary-list li {
        margin-bottom: 10px;
        font-size: 1rem;
    }
    .badge {
        border-radius: 20px;
        padding: 6px 12px;
        font-size: 0.9rem;
        display: inline-block;
    }
    .badge-excellent { background-color: #28a745; color: white; }
    .badge-good { background-color: #ffc107; color: black; }
    .badge-low { background-color: #dc3545; color: white; }
    .recent-entries table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 8px;
    }
    .recent-entries th, .recent-entries td {
        background: #f9f9f9;
        padding: 15px;
        border: none;
    }
    .recent-entries th {
        background: #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>

<div class="container my-4">

    <div class="card">
        <div class="card-header">📘 Internship Logbook Overview</div>

        <form method="GET" action="<?php echo e(route('supervisor.viewLogbook')); ?>">
            <div class="row g-3 align-items-end">
                <div class="col-md-8">
                    <label for="student_id" class="form-label">Select Student</label>
                    <select name="student_id" id="student_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- Choose a student --</option>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->id); ?>" <?php echo e(request('student_id') == $s->id ? 'selected' : ''); ?>>
                                <?php echo e($s->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4 text-end">
                    <?php if($selectedStudent): ?>
                        <button class="btn btn-primary" onclick="window.print()">🖨️ Print</button>
                    <?php endif; ?>
                </div>
            </div>
        </form>

        <?php if($selectedStudent): ?>
        <hr class="my-4">

        
        <div class="row">
            <div class="col-md-6">
                <h4><?php echo e($selectedStudent->name); ?></h4>
                <p><strong>ID:</strong> <?php echo e($selectedStudent->id); ?></p>
            </div>
            <div class="col-md-6 text-end">
                <?php
                    $attendanceCount = $attendances->count();
                    $lessonCount = $logbookEntries->count();
                    $diagramCount = $logbookEntries->whereNotNull('diagram_path')->count();

                    $attendanceScore = $attendanceCount / 7;

                    if ($attendanceScore < 5) {
                        $badgeClass = 'badge-low';
                        $status = '❌ Dangerously Low Attendance!';
                    } elseif ($attendanceScore == 5) {
                        $badgeClass = 'badge-good';
                        $status = '⚠️ Good Attendance!';
                    } else {
                        $badgeClass = 'badge-excellent';
                        $status = '✅ Excellent Attendance!';
                    }
                ?>

                <span class="badge <?php echo e($badgeClass); ?>">
                    <?php echo e($status); ?> (<?php echo e(number_format($attendanceScore, 1)); ?>/10)
                </span>
            </div>
        </div>

        
        <ul class="summary-list mt-3">
            <li><strong>Total Days Attended:</strong> <?php echo e($attendanceCount); ?> days</li>
            <li><strong>Lessons Learned:</strong> <?php echo e($lessonCount); ?> entries</li>
            <li><strong>Diagrams Uploaded:</strong> <?php echo e($diagramCount); ?> diagrams</li>
        </ul>

        <?php endif; ?>
    </div>

    
    <?php if($selectedStudent && $logbookEntries->isNotEmpty()): ?>
    <div class="card recent-entries">
        <div class="card-header">📝 Recent Logbook Entries</div>

        <table class="table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Work Done</th>
                    <th>Diagram</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $logbookEntries->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($entry->date)->format('D, M j, Y')); ?></td>
                    <td><?php echo e(\Illuminate\Support\Str::limit($entry->lesson_learned, 60)); ?></td>
                    <td>
                        <?php if($entry->diagram_path): ?>
                            <img src="<?php echo e(asset('storage/' . $entry->diagram_path)); ?>" alt="Diagram" width="80">
                        <?php else: ?>
                            <span class="text-muted">No Diagram</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

    </div>
    <?php endif; ?>

    
    <?php if($evaluation): ?>
    <div class="card">
        <div class="card-header">📋 Evaluation Summary</div>

        <ul class="summary-list">
            <li><strong>Punctuality:</strong> <?php echo e($evaluation->punctuality); ?>/10</li>
            <li><strong>Attitude:</strong> <?php echo e($evaluation->attitude); ?>/10</li>
            <li><strong>Skill Acquisition:</strong> <?php echo e($evaluation->skill_acquisition); ?>/10</li>
            <li><strong>Report Quality:</strong> <?php echo e($evaluation->report_quality); ?>/10</li>
            <li><strong>Remarks:</strong> <?php echo e($evaluation->remarks ?? 'No remarks'); ?></li>
        </ul>
    </div>
    <?php endif; ?>

    <?php if(Auth::user()->role == 'admin'): ?>
    <?php if($selectedStudent->logbook_approved != Null): ?>
    <div class="alert alert-success mt-3">
        <strong>Status:</strong> Logbook Approved ✅
    </div>
<?php endif; ?>

    <form method="POST" action="<?php echo e(route('admin.toggleLogbookApproval', $selectedStudent->id)); ?>">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn btn-<?php echo e($selectedStudent->logbook_approved ? 'danger' : 'success'); ?> btn-lg">
            <?php echo e($selectedStudent->logbook_approved ? '❌ Cancel Approval' : '✅ Approve Logbook'); ?>

        </button>
    </form>

<?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/supervisors/view-logbook.blade.php ENDPATH**/ ?>