<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Interns Management</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('app/assets/img/favicon.png')}}" rel="icon">
  <link href="{{ asset('app/assets/img/apple-touch-icon.png')}}" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('app/assets/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">
  <link href="{{ asset('app/assets/vendor/bootstrap-icons/bootstrap-icons.css')}}" rel="stylesheet">
  <link href="{{ asset('app/assets/vendor/aos/aos.css')}}" rel="stylesheet">
  <link href="{{ asset('app/assets/vendor/glightbox/css/glightbox.min.css')}}" rel="stylesheet">
  <link href="{{ asset('app/assets/vendor/swiper/swiper-bundle.min.css')}}" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="{{ asset('app/assets/css/main.css')}}" rel="stylesheet">


</head>

<body class="index-page">

  <header id="header" class="header d-flex align-items-center fixed-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center">

      <a href="/" class="logo d-flex align-items-center me-auto">
        <!-- Uncomment the line below if you also wish to use an image logo -->
        <!-- <img src="assets/img/logo.png" alt=""> -->
        <h1 class="sitename">Intern-Manager</h1>
      </a>

      <nav id="navmenu" class="navmenu">
        <ul>
          <li><a href="#hero" class="active">Home</a></li>
          <li><a href="#about">About</a></li>
          <li><a href="#services">School Website</a></li>
          {{-- <li class="dropdown"><a href="#"><span>Dropdown</span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
            <ul>
              <li><a href="#">Dropdown 1</a></li>
              <li class="dropdown"><a href="#"><span>Deep Dropdown</span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
                <ul>
                  <li><a href="#">Deep Dropdown 1</a></li>
                  <li><a href="#">Deep Dropdown 2</a></li>
                  <li><a href="#">Deep Dropdown 3</a></li>
                  <li><a href="#">Deep Dropdown 4</a></li>
                  <li><a href="#">Deep Dropdown 5</a></li>
                </ul>
              </li>
              <li><a href="#">Dropdown 2</a></li>
              <li><a href="#">Dropdown 3</a></li>
              <li><a href="#">Dropdown 4</a></li>
            </ul>
          </li> --}}
          <li class="dropdown">
            <a href="#"><span>Account</span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
            <ul>
              <li><a href="{{ route('register') }}">Register</a></li>
              <li><a href="{{ route('login') }}">Login</a></li>
            </ul>
          </li>

        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
      </nav>

      <a class="cta-btn" href="/register">Get Started</a>

    </div>
  </header>

  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">

      <img src="{{ asset('app/assets/img/hero-bg.jpg')}}" alt="" data-aos="fade-in">

      <div class="container d-flex flex-column align-items-center">
        <h2 data-aos="fade-up" data-aos-delay="100">SIGN UP. INTERN. GROW.</h2>
        <p data-aos="fade-up"
        data-aos-delay="200">
        Get started with making interships work
        </p>
        <div class="d-flex mt-4" data-aos="fade-up" data-aos-delay="300">
          <a href="/register" class="btn-get-started">Get Started</a>
          <a href="/login"
          class="glightbox btn-watch-video d-flex align-items-center">
          <i class="bi bi-play-circle"></i>
          <span>Login</span>
        </a>
        </div>
      </div>
    </section><!-- /Hero Section -->

 <!-- About Section -->
<section id="about" class="about section">
    <div class="container">
      <div class="row gy-4">
        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">
          <h3>Effortless SIWES Management and Real-Time Internship Monitoring</h3>
          <img src="{{ asset('app/assets/img/about.jpg')}}" class="img-fluid rounded-4 mb-4" alt="Internship Management System">
          <p>
            The Internship Placement and Monitoring System (IPMS) is designed to streamline the **Student Industrial Work Experience Scheme (SIWES)** by providing a structured platform for easy management, seamless communication, and accurate record-keeping.
          </p>
          <p>
            With a robust tracking system, real-time supervisor evaluations, and an **automated daily sign-in system**, students, supervisors, and administrators can manage internships efficiently. The platform eliminates paperwork, reduces errors, and enhances transparency.
          </p>
        </div>

        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="250">
          <div class="content ps-0 ps-lg-5">
            <p class="fst-italic">
              A **fully digital** SIWES management system that simplifies **internship placement, tracking, and assessment**.
            </p>
            <ul>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Automated Internship Placement:** Students can apply for internships, and coordinators can approve placements online.</span></li>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Daily Sign-In & Attendance Tracking:** Students log their attendance, ensuring real-time monitoring of participation.</span></li>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Supervisor Evaluation System:** Supervisors can assess students' progress, grade project documents/software, and provide feedback instantly.</span></li>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Internship Coordinator Dashboard:** Coordinators can manage student records, internship placements, and generate reports effortlessly.</span></li>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Instant Notifications & Communication:** Integrated messaging system for smooth interactions between students, supervisors, and administrators.</span></li>
              <li><i class="bi bi-check-circle-fill"></i> <span>**Secure Cloud-Based Record Keeping:** All internship records are stored securely, ensuring accessibility and data integrity.</span></li>
            </ul>
            <p>
              With **IPMS**, organizations can **enhance internship efficiency**, while students benefit from a **structured and monitored learning experience**.
              Stay ahead with **real-time progress tracking, paperless reporting, and digital grading**—all in one place.
            </p>

            <div class="position-relative mt-4">
              <img src="{{ asset('app/assets/img/siwes.jpg')}}" class="img-fluid rounded-4"
               alt="Internship System">
              {{-- <a href="https://www.youtube.com/watch?v=Y7f98aduVJ8" class="glightbox pulsating-play-btn"></a> --}}
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /About Section -->

<!-- Stats Section -->
<section id="stats" class="stats section light-background">

    <div class="container" data-aos="fade-up" data-aos-delay="100">

      <div class="row gy-4">

        <div class="col-lg-3 col-md-6">
          <div class="stats-item d-flex align-items-center w-100 h-100">
            <i class="bi bi-people color-blue flex-shrink-0"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="500" data-purecounter-duration="1" class="purecounter"></span>
              <p>Registered Interns</p>
            </div>
          </div>
        </div><!-- End Stats Item -->

        <div class="col-lg-3 col-md-6">
          <div class="stats-item d-flex align-items-center w-100 h-100">
            <i class="bi bi-clipboard-check color-orange flex-shrink-0"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="1200" data-purecounter-duration="1" class="purecounter"></span>
              <p>Daily Sign-ins</p>
            </div>
          </div>
        </div><!-- End Stats Item -->

        <div class="col-lg-3 col-md-6">
          <div class="stats-item d-flex align-items-center w-100 h-100">
            <i class="bi bi-briefcase color-green flex-shrink-0"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="200" data-purecounter-duration="1" class="purecounter"></span>
              <p>Internship Companies</p>
            </div>
          </div>
        </div><!-- End Stats Item -->

        <div class="col-lg-3 col-md-6">
          <div class="stats-item d-flex align-items-center w-100 h-100">
            <i class="bi bi-person-check color-pink flex-shrink-0"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="50" data-purecounter-duration="1" class="purecounter"></span>
              <p>Coordinators & Supervisors</p>
            </div>
          </div>
        </div><!-- End Stats Item -->

      </div>

    </div>

  </section><!-- /Stats Section -->

  <!-- Services Section -->
<section id="services-2" class="services-2 section light-background">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
      <h2>Services</h2>
      <p>SIWES MANAGEMENT FEATURES</p>
    </div><!-- End Section Title -->

    <div class="container">

      <div class="row gy-4">

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="100">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-journal-text icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Internship Record Keeping</a></h4>
              <p class="description">Coordinators can track and manage intern progress, attendance, and reports in one place.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-calendar-check icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Daily Sign-in System</a></h4>
              <p class="description">Interns can sign in daily via the platform, ensuring accurate attendance tracking.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-folder-check icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Supervisor Assessments</a></h4>
              <p class="description">Supervisors can evaluate interns, leave feedback, and rate their performance.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-file-earmark-text icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Automated Report Generation</a></h4>
              <p class="description">Interns can generate automated reports and logs based on their daily sign-ins and tasks.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="500">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-building icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Internship Placement Support</a></h4>
              <p class="description">The platform helps interns find available companies for industrial training.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

        <div class="col-md-6" data-aos="fade-up" data-aos-delay="600">
          <div class="service-item d-flex position-relative h-100">
            <i class="bi bi-envelope-paper icon flex-shrink-0"></i>
            <div>
              <h4 class="title"><a href="#" class="stretched-link">Internship Completion Certificates</a></h4>
              <p class="description">Interns receive digitally verified certificates upon successful SIWES completion.</p>
            </div>
          </div>
        </div><!-- End Service Item -->

      </div>

    </div>

  </section><!-- /Services Section -->


<!-- Contact Section -->
<section id="contact" class="contact section">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
      <h2>Contact</h2>
      <p>We're here to assist you!</p>
    </div><!-- End Section Title -->

    <div class="container" data-aos="fade-up" data-aos-delay="100">

      <div class="row gy-4">
        <div class="col-lg-6 ">
          <div class="row gy-4">

            <div class="col-lg-12">
              <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="200">
                <i class="bi bi-geo-alt"></i>
                <h3>Address</h3>
                <p>Abuja, Nigeria</p>
              </div>
            </div><!-- End Info Item -->

            <div class="col-md-6">
              <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="300">
                <i class="bi bi-telephone"></i>
                <h3>Call Us</h3>
                <p>Support Hours: Mon – Fri, 9 AM – 5 PM (EST)</p>
              </div>
            </div><!-- End Info Item -->

            <div class="col-md-6">
              <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="400">
                <i class="bi bi-envelope"></i>
                <h3>Email Us</h3>
                <p>myhappyplace1082@gmail.com</p>
              </div>
            </div><!-- End Info Item -->

          </div>
        </div>

        <div class="col-lg-6">
          <form action="forms/contact.php" method="post" class="php-email-form" data-aos="fade-up" data-aos-delay="500">
            <div class="row gy-4">

              <div class="col-md-6">
                <input type="text" name="name" class="form-control" placeholder="Your Name" required="">
              </div>

              <div class="col-md-6 ">
                <input type="email" class="form-control" name="email" placeholder="Your Email" required="">
              </div>

              <div class="col-md-12">
                <input type="text" class="form-control" name="subject" placeholder="Subject" required="">
              </div>

              <div class="col-md-12">
                <textarea class="form-control" name="message" rows="4" placeholder="Message" required=""></textarea>
              </div>

              <div class="col-md-12 text-center">
                <div class="loading">Loading</div>
                <div class="error-message"></div>
                <div class="sent-message">Your message has been sent. Thank you!</div>

                <button type="submit">Send Message</button>
              </div>

            </div>
          </form>
        </div><!-- End Contact Form -->

      </div>

    </div>

  </section><!-- /Contact Section -->

  </main>

  <footer id="footer" class="footer dark-background">

    <div class="container footer-top">
      <div class="row gy-4">
        <div class="col-lg-4 col-md-6 footer-about">
          <a href="index.html" class="logo d-flex align-items-center">
            <span class="sitename">IPMS</span>
          </a>
          <div class="footer-contact pt-3">
            <p>Abuja, Nigeria</p>
            <p class="mt-3"><strong>Phone:</strong> <span>Support Hours: Mon – Fri, 9 AM – 5 PM (WAT)</span></p>
            <p><strong>Email:</strong> <span>admin@internmanager.com</span></p>
            <p><strong>Email:</strong> <span>admin@ipms.com.ng</span></p>
          </div>
          <div class="social-links d-flex mt-4">
            <a href="#"><i class="bi bi-twitter-x"></i></a>
            <a href="#"><i class="bi bi-facebook"></i></a>
            <a href="#"><i class="bi bi-instagram"></i></a>
            <a href="#"><i class="bi bi-linkedin"></i></a>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Useful Links</h4>
          <ul>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Home</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">About Us</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Services</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Terms of Service</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Privacy Policy</a></li>
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Our Services</h4>
          <ul>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Internship Management</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Company Partnerships</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Intern Support</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Training & Workshops</a></li>
            <li><i class="bi bi-chevron-right"></i> <a href="#">Career Guidance</a></li>
          </ul>
        </div>

        <div class="col-lg-4 col-md-12 footer-newsletter">
          <h4>Our Newsletter</h4>
          <p>Subscribe to receive updates on internships, career opportunities, and company partnerships!</p>
          <form action="forms/newsletter.php" method="post" class="php-email-form">
            <div class="newsletter-form">
              <input type="email" name="email" placeholder="Enter your email">
              <input type="submit" value="Subscribe">
            </div>
            <div class="loading">Loading</div>
            <div class="error-message"></div>
            <div class="sent-message">Your subscription request has been sent. Thank you!</div>
          </form>
        </div>

      </div>
    </div>

    <div class="container copyright text-center mt-4">
      <p>© <span>Copyright</span> <strong class="px-1 sitename">IPMS</strong> <span>All Rights Reserved</span></p>
    </div>

  </footer>


  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  {{-- <div id="preloader"></div> --}}

  <!-- Vendor JS Files -->
  <script src="{{ asset('app/assets/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/php-email-form/validate.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/aos/aos.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/glightbox/js/glightbox.min.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/purecounter/purecounter_vanilla.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/swiper/swiper-bundle.min.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js')}}"></script>
  <script src="{{ asset('app/assets/vendor/isotope-layout/isotope.pkgd.min.js')}}"></script>

  <!-- Main JS File -->
  <script src="{{ asset('app/assets/js/main.js')}}"></script>

</body>

</html>
