@extends('layouts.dash')

@section('content')
@include('inc.header')

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="container py-4">
    <h2 class="mb-4">🎯 Evaluate Students</h2>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        {{-- Evaluation Form --}}
        <div class="col-md-6">
            <form method="GET" action="{{ route('evaluations.index') }}">
                <label for="student_id" class="form-label">Select Student</label>
                <select name="student_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Choose a student --</option>
                    @foreach($students as $student)
                        @php
                            $hasAttendance = \App\Models\Attendance::where('student_id', $student->id)->exists();
                            $alreadyEvaluated = \App\Models\Evaluation::where('student_id', $student->id)->exists();
                        @endphp
                        <option value="{{ $student->id }}"
                            @if(!$hasAttendance || $alreadyEvaluated) disabled @endif
                            @if(request('student_id') == $student->id) selected @endif>
                            {{ $student->name }}
                            @if(!$hasAttendance) - No Attendance
                            @elseif($alreadyEvaluated) - Already Evaluated
                            @endif
                        </option>
                    @endforeach
                </select>
            </form>

            @if(request('student_id'))
                @php
                    $student = \App\Models\User::find(request('student_id'));
                    $hasAttendance = \App\Models\Attendance::where('student_id', $student->id)->exists();
                    $alreadyEvaluated = \App\Models\Evaluation::where('student_id', $student->id)->first();
                @endphp

                @if(!$hasAttendance)
                    <div class="alert alert-danger mt-3">
                        Student has no attendance records to be evaluated!
                    </div>
                @elseif($alreadyEvaluated)
                    <div class="alert alert-warning mt-3 d-flex justify-content-between align-items-center">
                        <span>Student has already been evaluated.</span>
                        <a href="{{ route('evaluations.edit', $alreadyEvaluated->id) }}" class="btn btn-sm btn-outline-primary">Edit Evaluation</a>
                    </div>
                @else
                    <form method="POST" action="{{ route('evaluations.store') }}" class="mt-4">
                        @csrf
                        <input type="hidden" name="student_id" value="{{ $student->id }}">

                        <div class="mb-3">
                            <label>Punctuality</label>
                            <input type="number" name="punctuality" class="form-control @error('punctuality') is-invalid @enderror" max="10" value="{{ old('punctuality') }}" required>
                            @error('punctuality') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label>Attitude</label>
                            <input type="number" name="attitude" class="form-control @error('attitude') is-invalid @enderror" max="10" value="{{ old('attitude') }}" required>
                            @error('attitude') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label>Skill Acquisition</label>
                            <input type="number" name="skill_acquisition" class="form-control @error('skill_acquisition') is-invalid @enderror" max="10" value="{{ old('skill_acquisition') }}" required>
                            @error('skill_acquisition') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label>Report Quality</label>
                            <input type="number" name="report_quality" class="form-control @error('report_quality') is-invalid @enderror" max="10" value="{{ old('report_quality') }}" required>
                            @error('report_quality') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label>Remarks</label>
                            <textarea name="remarks" class="form-control @error('remarks') is-invalid @enderror" rows="3" placeholder="Optional remarks...">{{ old('remarks') }}</textarea>
                            @error('remarks') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <button class="btn btn-primary w-100">💾 Submit Evaluation</button>
                    </form>
                @endif
            @endif
        </div>

        {{-- Chart Breakdown --}}
        <div class="col-md-6">
            <h5 class="mb-3">📊 Average Evaluation Breakdown</h5>
            <canvas id="evaluationChart"></canvas>
        </div>
    </div>

    {{-- Past Evaluations --}}
    <div class="mt-5">
        <h4>📄 Past Evaluations</h4>
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Student</th>
                        <th>Punctuality</th>
                        <th>Attitude</th>
                        <th>Skill</th>
                        <th>Report</th>
                        <th>Remarks</th>
                        <th>Updated</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($evaluations as $eval)
                        <tr>
                            <td>{{ $eval->student->name }}</td>
                            <td>{{ $eval->punctuality }}</td>
                            <td>{{ $eval->attitude }}</td>
                            <td>{{ $eval->skill_acquisition }}</td>
                            <td>{{ $eval->report_quality }}</td>
                            <td>{{ $eval->remarks ?? '-' }}</td>
                            <td>{{ $eval->updated_at->diffForHumans() }}</td>
                            <td>

                                <a href="{{ route('evaluations.edit', $eval->id) }}" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i> Edit
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="8" class="text-center">No evaluations found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Chart Script --}}
<script>
    const ctx = document.getElementById('evaluationChart');
    const chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Punctuality', 'Attitude', 'Skill', 'Report'],
            datasets: [{
                label: 'Avg Score',
                data: [
                    {{ $averages['punctuality'] ?? 0 }},
                    {{ $averages['attitude'] ?? 0 }},
                    {{ $averages['skill_acquisition'] ?? 0 }},
                    {{ $averages['report_quality'] ?? 0 }}
                ],
                backgroundColor: ['#0d6efd', '#198754', '#ffc107', '#6f42c1']
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    max: 10
                }
            }
        }
    });
</script>
@endsection
