@extends('layouts.dash')

@section('content')
@include('inc.header')

{{-- Include Select2 CSS --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="container mt-4">
    <h3 class="mb-4">🎯 Evaluate a Student</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <form method="POST" action="{{ route('evaluations.store') }}">
                @csrf

                <div class="mb-3">
                    <label for="student_id" class="form-label fw-bold">Select Student</label>
                    <select name="student_id" class="form-select select2" required>
                        <option value="">-- Choose Student --</option>
                        @foreach($students as $student)
                            <option value="{{ $student->id }}">{{ $student->name }} ({{ $student->email }})</option>
                        @endforeach
                    </select>
                </div>

                <div class="row">
                    @foreach(['punctuality', 'attitude', 'skill_acquisition', 'report_quality'] as $criteria)
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-capitalize fw-semibold">
                                {{ ucwords(str_replace('_', ' ', $criteria)) }} (1-10)
                            </label>
                            <input type="number" name="{{ $criteria }}" class="form-control" min="1" max="10" required>
                        </div>
                    @endforeach
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Remarks</label>
                    <textarea name="remarks" rows="3" class="form-control" placeholder="Optional remarks..."></textarea>
                </div>

                <div class="text-end">
                    <button class="btn btn-primary">
                        <i class="fas fa-paper-plane me-1"></i> Submit Evaluation
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Include Select2 JS --}}
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        $('.select2').select2({
            placeholder: "-- Choose Student --",
            width: '100%'
        });
    });
</script>
@endsection
