@extends('layouts.dash')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white text-center">
                    <h4>{{ __('Register') }}</h4>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('register') }}">
                        @csrf

                        <!-- Name -->
                        <div class="mb-3">
                            <label for="name" class="form-label">{{ __('Full Name') }}</label>
                            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autofocus>
                            @error('name')
                                <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label for="email" class="form-label">{{ __('Email Address') }}</label>
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required>
                            @error('email')
                                <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <!-- Role Selection -->
                        <div class="mb-3">
                            <label for="role" class="form-label">{{ __('Register As') }}</label>
                            <select id="role" name="role" class="form-select @error('role') is-invalid @enderror" required>
                                <option value="" selected disabled>-- Select Role --</option>
                                <option value="student">Student</option>
                                <option value="supervisor">Supervisor</option>
                            </select>
                            @error('role')
                                <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <!-- Student-Only Fields (Hidden by Default) -->
                        <div id="studentFields" style="display: none;">
                            <!-- Matric Number -->
                            <div class="mb-3">
                                <label for="matric" class="form-label">{{ __('Matric Number') }}</label>
                                <input id="matric" type="text" class="form-control" name="matric">
                            </div>

                            <!-- Department -->
                            <div class="mb-3">
                                <label for="department" class="form-label">{{ __('Department') }}</label>
                                <select id="department" name="department" class="form-select">
                                    <option value="" selected disabled>-- Select Department --</option>
                                    <option value="CSC">Computer Science</option>
                                    <option value="BAM">Business Administration</option>
                                    <option value="MAC">Mass Communication</option>
                                    <option value="EEE">Electrical Engineering</option>
                                    <option value="CE">Civil Engineering</option>
                                </select>
                            </div>

                            <!-- Level -->
                            <div class="mb-3">
                                <label for="level" class="form-label">{{ __('Level') }}</label>
                                <select id="level" name="level" class="form-select">
                                    <option value="" selected disabled>-- Select Level --</option>
                                    <optgroup label="ND Levels">
                                        <option value="ND1">ND 1</option>
                                        <option value="ND2">ND 2</option>
                                        <option value="ND3">ND 3</option>
                                        <option value="ND4">ND 4</option>
                                    </optgroup>
                                    <optgroup label="HND Levels">
                                        <option value="HND1">HND 1</option>
                                        <option value="HND2">HND 2</option>
                                        <option value="HND3">HND 3</option>
                                        <option value="HND4">HND 4</option>
                                    </optgroup>
                                </select>
                            </div>
                        </div>

                        <!-- Password -->
                        <div class="mb-3">
                            <label for="password" class="form-label">{{ __('Password') }}</label>
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required>
                            @error('password')
                                <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <!-- Confirm Password -->
                        <div class="mb-3">
                            <label for="password-confirm" class="form-label">{{ __('Confirm Password') }}</label>
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required>
                        </div>

                        <!-- Submit Button -->
                        <div class="d-grid justify-between">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-user-plus"></i> {{ __('Register') }}
                            </button>
                            <a href="/login">Login Instead?</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for Role Selection -->
<script>
    document.getElementById('role').addEventListener('change', function() {
        let studentFields = document.getElementById('studentFields');
        studentFields.style.display = this.value === 'student' ? 'block' : 'none';
    });
</script>
@endsection
