@extends('layouts.dash')

@section('content')
    <h2>{{ $student->supervisor_id ? 'Change' : 'Assign' }} Supervisor to {{ $student->name }}</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('admin.students.assign.update', $student->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="supervisor_id">Supervisor:</label>
            <select name="supervisor_id" class="form-control">
                <option value="">-- None --</option>
                @foreach($supervisors as $supervisor)
                    <option value="{{ $supervisor->id }}"
                        {{ $student->supervisor_id == $supervisor->id ? 'selected' : '' }}>
                        {{ $supervisor->name }} ({{ $supervisor->email }})
                    </option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-success mt-3">Save</button>
        <a href="{{ route('admin.students.index') }}" class="btn btn-secondary mt-3">Back</a>
    </form>
@endsection
