<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'matric',
        'level',
        'department',

    ];

    // Get supervisor (for students)
public function supervisor()
{
    return $this->belongsTo(User::class, 'supervisor_id');
}

// Get students (for supervisors)
public function students()
{
    return $this->hasMany(User::class, 'supervisor_id');
}

// In User.php

public function attendances()
{
    return $this->hasMany(Attendance::class, 'student_id');
}

public function evaluations()
{
    return $this->hasMany(Evaluation::class, 'student_id');
}


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
